<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwsplits wwmode wwfiles wwdoc wwbehaviors wwproject wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDocumentType" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterEmitTableEntries" select="'false'" />


 <xsl:namespace-alias stylesheet-prefix="wwsplits" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-documentid" match="wwfiles:File" use="@documentID" />
 <xsl:key name="wwbehaviors-splits-by-id" match="wwbehaviors:Split" use="@id" />
 <xsl:key name="wwbehaviors-markers-by-id" match="wwbehaviors:Marker" use="@id" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarProgressProjectGroupsStart" select="wwprogress:Start(count($VarProjectGroups))" />
   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />
    <xsl:variable name="VarProjectGroupPosition" select="position()" />

    <xsl:variable name="VarProgressProjectGroupStart" select="wwprogress:Start(1)" />

    <!-- Aborted? -->
    <!--          -->
    <xsl:if test="not(wwprogress:Abort())">
     <!-- Documents -->
     <!--           -->
     <xsl:variable name="VarProjectDocuments" select="$VarProjectGroup//wwproject:Document" />
     <xsl:variable name="VarProgressProjectDocumentsStart" select="wwprogress:Start(count($VarProjectDocuments))" />
     <xsl:for-each select="$VarProjectDocuments">
      <xsl:variable name="VarProjectDocument" select="." />
      <xsl:variable name="VarProjectDocumentPosition" select="position()" />

      <xsl:variable name="VarProgressProjectDocumentStart" select="wwprogress:Start(1)" />

      <!-- Aborted? -->
      <!--          -->
      <xsl:if test="not(wwprogress:Abort())">
       <!-- Splits -->
       <!--        -->
       <xsl:for-each select="$GlobalFiles[1]">
        <xsl:variable name="VarFilesWithDocumentID" select="key('wwfiles-files-by-documentid', $VarProjectDocument/@DocumentID)" />

        <!-- Load splits -->
        <!--             -->
        <xsl:variable name="VarFilesSplits" select="$VarFilesWithDocumentID[@type = $ParameterDependsType][1]" />
        <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

        <xsl:variable name="VarFilesDocument" select="$VarFilesWithDocumentID[@type = $ParameterDocumentType][1]" />
        <xsl:for-each select="$VarFilesDocument[1]">
         <xsl:variable name="VarFilesBehaviors" select="$VarFilesWithDocumentID[@type = $ParameterBehaviorsType][1]" />
         <xsl:for-each select="$VarFilesBehaviors[1]">
          <!-- Call template -->
          <!--               -->
          <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFilesSplits/@path), concat(translate($ParameterType, ':', '_'),'.xml'))" />
          <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, '', $VarFilesSplits/@groupID, $VarFilesSplits/@documentID, $GlobalActionChecksum)" />
          <xsl:if test="not($VarUpToDate)">
           <xsl:variable name="VarResultAsXML">
            <!-- Load document -->
            <!--               -->
            <xsl:variable name="VarDocument" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />
            <xsl:variable name="VarBehaviors" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesBehaviors/@path)" />

            <xsl:call-template name="NameInfo">
             <xsl:with-param name="ParamProjectGroup" select="$VarProjectGroup" />
             <xsl:with-param name="ParamProjectGroupPosition" select="$VarProjectGroupPosition" />
             <xsl:with-param name="ParamProjectDocument" select="$VarProjectDocument" />
             <xsl:with-param name="ParamProjectDocumentPosition" select="$VarProjectDocumentPosition" />
             <xsl:with-param name="ParamDocument" select="$VarDocument" />
             <xsl:with-param name="ParamBehaviors" select="$VarBehaviors" />
             <xsl:with-param name="ParamSplits" select="$VarSplits" />
            </xsl:call-template>
           </xsl:variable>
           <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
           <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
          </xsl:if>

          <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" actionchecksum="{$GlobalActionChecksum}">
           <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
           <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
           <wwfiles:Depends path="{$VarFilesBehaviors/@path}" checksum="{$VarFilesBehaviors/@checksum}" groupID="{$VarFilesBehaviors/@groupID}" documentID="{$VarFilesBehaviors/@documentID}" />
          </wwfiles:File>
         </xsl:for-each>
        </xsl:for-each>
       </xsl:for-each>
      </xsl:if>

      <xsl:variable name="VarProgressProjectDocumentEnd" select="wwprogress:End()" />
     </xsl:for-each>

     <xsl:variable name="VarProgressProjectDocumentsEnd" select="wwprogress:End()" />
    </xsl:if>

    <xsl:variable name="VarProgressProjectGroupEndt" select="wwprogress:End()" />
   </xsl:for-each>

   <xsl:variable name="VarProgressProjectGroupsEnd" select="wwprogress:End()" />
  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="GetFileNameMarkers">
  <xsl:param name="ParamBehaviors" />
  <xsl:param name="ParamMarkers" />

  <!-- Create filename markers -->
  <!--                         -->
  <xsl:for-each select="$ParamMarkers">
   <xsl:variable name="VarMarker" select="." />

   <xsl:for-each select="$ParamBehaviors[1]">
    <xsl:variable name="VarBehaviorMarker" select="key('wwbehaviors-markers-by-id', $VarMarker/@id)" />

    <xsl:for-each select="$VarBehaviorMarker[1][(@behavior = 'filename') or (@behavior = 'filename-and-topic')]">
     <xsl:variable name="VarFileName">
      <xsl:for-each select="$VarMarker/wwdoc:TextRun/wwdoc:Text">
       <xsl:value-of select="@value" />
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarNormalizedFileName" select="normalize-space($VarFileName)" />

     <xsl:if test="string-length($VarNormalizedFileName) &gt; 0">
      <wwsplits:FileName value="{$VarNormalizedFileName}" />
     </xsl:if>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="NameInfo">
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamProjectGroupPosition" />
  <xsl:param name="ParamProjectDocument" />
  <xsl:param name="ParamProjectDocumentPosition" />
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamBehaviors" />
  <xsl:param name="ParamSplits" />

  <xsl:variable name="VarDocumentNameWithoutExtension" select="wwfilesystem:GetFileNameWithoutExtension(wwprojext:GetDocumentPath($ParamProjectDocument/@DocumentID))" />

  <wwsplits:Splits version="1.0">
   <xsl:for-each select="$ParamSplits/wwsplits:Splits/wwsplits:Split">
    <xsl:variable name="VarSplit" select="." />
    <xsl:variable name="VarPosition" select="position()" />

    <!-- Identify start/end positions -->
    <!--                              -->
    <xsl:variable name="VarStartPosition" select="@documentposition" />
    <xsl:variable name="VarEndPosition">
     <xsl:choose>
      <xsl:when test="position() = last()">
       <xsl:value-of select="count($ParamDocument/wwdoc:Document/wwdoc:Content/*)" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:value-of select="following-sibling::wwsplits:Split[1]/@documentposition - 1" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>

    <!-- Select content -->
    <!--                -->
    <xsl:variable name="VarContent" select="$ParamDocument/wwdoc:Document/wwdoc:Content/*[(position() &gt;= $VarStartPosition) and (position() &lt;= $VarEndPosition)]" />

    <xsl:variable name="VarSplitTitle">
     <xsl:for-each select="($VarContent[(local-name() = 'Paragraph') and (count(./wwdoc:TextRun/wwdoc:Text) &gt; 0)][1] | $VarContent//wwdoc:Paragraph[not(ancestor::wwdoc:Frame) and (count(./wwdoc:TextRun/wwdoc:Text) &gt; 0)][1])[1]/wwdoc:TextRun/wwdoc:Text">
      <xsl:value-of select="@value" />
     </xsl:for-each>
    </xsl:variable>

    <!-- Split behavior -->
    <!--                -->
    <xsl:for-each select="$ParamBehaviors[1]">
     <xsl:variable name="VarBehaviorsSplit" select="key('wwbehaviors-splits-by-id', $VarSplit/@id)[1]" />

     <!-- Window type -->
     <!--             -->
     <xsl:variable name="VarWindowType" select="$VarBehaviorsSplit/@window-type" />

     <!-- Name Info -->
     <!--           -->
     <wwsplits:Split groupID="{$ParamProjectGroup/@GroupID}" documentID="{$ParamProjectDocument/@DocumentID}" id="{$VarSplit/@id}" position="{$VarPosition}" documentstartposition="{$VarStartPosition}" documentendposition="{$VarEndPosition}" title="{$VarSplitTitle}">
      <xsl:if test="string-length($VarWindowType) &gt; 0">
       <xsl:attribute name="window-type">
        <xsl:value-of select="$VarWindowType" />
       </xsl:attribute>
      </xsl:if>
      <wwsplits:Group name="{$ParamProjectGroup/@Name}" id="{$ParamProjectGroup/@GroupID}" position="{$ParamProjectGroupPosition}" />
      <wwsplits:Document path="{wwprojext:GetDocumentPath($ParamProjectDocument/@DocumentID)}" id="{$ParamProjectDocument/@DocumentID}" position="{$ParamProjectDocumentPosition}" />

      <!-- Select page markers -->
      <!--                     -->
      <xsl:variable name="VarPageMarkers" select="$VarContent/wwdoc:Marker | $VarContent//wwdoc:Marker[count(ancestor::wwdoc:Frame[1]) = 0]" />

      <!-- Get last file name marker -->
      <!--                           -->
      <xsl:variable name="VarPageFileNameMarkersAsXML">
       <xsl:call-template name="GetFileNameMarkers">
        <xsl:with-param name="ParamBehaviors" select="$ParamBehaviors" />
        <xsl:with-param name="ParamMarkers" select="$VarPageMarkers" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarPageFileNameMarkers" select="msxsl:node-set($VarPageFileNameMarkersAsXML)/wwsplits:FileName" />
      <xsl:copy-of select="$VarPageFileNameMarkers[count($VarPageFileNameMarkers)]" />

      <!-- Get last page style marker -->
      <!--                            -->
      <xsl:variable name="VarPageStyle">
       <xsl:variable name="VarPageStyleMarkers" select="$VarPageMarkers[@name = 'PageStyle']" />
       <xsl:variable name="VarPageStyleMarkersCount" select="count($VarPageStyleMarkers)" />
       <xsl:choose>
        <xsl:when test="$VarPageStyleMarkersCount &gt; 0">
         <xsl:for-each select="$VarPageStyleMarkers[$VarPageStyleMarkersCount]/wwdoc:TextRun/wwdoc:Text">
          <xsl:value-of select="@value" />
         </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="'Default'" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>
      <wwsplits:PageStyle value="{$VarPageStyle}" />

      <!-- Get frames -->
      <!--            -->
      <wwsplits:Frames>
       <xsl:variable name="VarFrames" select="$VarContent[local-name() = 'Frame'] | $VarContent//wwdoc:Frame[count(ancestor::wwdoc:Frame[1]) = 0]" />
       <xsl:for-each select="$VarFrames">
        <xsl:variable name="VarFrame" select="." />

        <xsl:variable name="VarFrameTitle">
         <xsl:for-each select="$VarFrame/wwdoc:Description/wwdoc:Paragraph[1]/wwdoc:TextRun/wwdoc:Text">
          <xsl:value-of select="@value" />
         </xsl:for-each>
        </xsl:variable>

        <wwsplits:Frame position="{position()}" title="{$VarFrameTitle}">
         <xsl:copy-of select="$VarFrame" />

         <!-- Select frame markers -->
         <!--                      -->
         <xsl:variable name="VarFrameMarkers" select="$VarFrame//wwdoc:Marker" />

         <!-- Get last file name marker -->
         <!--                           -->
         <xsl:variable name="VarFrameFileNameMarkersAsXML">
          <xsl:call-template name="GetFileNameMarkers">
           <xsl:with-param name="ParamBehaviors" select="$ParamBehaviors" />
           <xsl:with-param name="ParamMarkers" select="$VarFrameMarkers" />
          </xsl:call-template>
         </xsl:variable>
         <xsl:variable name="VarFrameFileNameMarkers" select="msxsl:node-set($VarFrameFileNameMarkersAsXML)/wwsplits:FileName" />
         <xsl:copy-of select="$VarFrameFileNameMarkers[count($VarFrameFileNameMarkers)]" />
        </wwsplits:Frame>
       </xsl:for-each>
      </wwsplits:Frames>

      <!-- Emit Table file names if supported -->
      <!--                                    -->
      <xsl:if test="$ParameterEmitTableEntries = 'true'">
       <wwsplits:Tables>
        <xsl:variable name="VarTables" select="$VarBehaviorsSplit//wwbehaviors:Table" />
        <xsl:for-each select="$VarTables">
         <xsl:variable name="VarTable" select="." />

         <wwsplits:Table groupID="{$ParamProjectGroup/@GroupID}" documentID="{$ParamProjectDocument/@DocumentID}" id="{$VarTable/@id}" position="{position()}" />
        </xsl:for-each>
       </wwsplits:Tables>
      </xsl:if>

      <!-- Emit Popup file names if supported -->
      <!--                                    -->
      <wwsplits:Popups>
       <xsl:variable name="VarPopupDefineParagraphs" select="$VarBehaviorsSplit//wwbehaviors:Paragraph[(@popup = 'define') or (@popup = 'define-no-output')]" />

       <xsl:for-each select="$VarPopupDefineParagraphs">
        <xsl:variable name="VarPopupParagraph" select="." />

        <wwsplits:Popup groupID="{$ParamProjectGroup/@GroupID}" documentID="{$ParamProjectDocument/@DocumentID}" id="{$VarPopupParagraph/@id}" stylename="{$VarPopupParagraph/@popup-page-rule}" />
       </xsl:for-each>
      </wwsplits:Popups>
     </wwsplits:Split>
    </xsl:for-each>
   </xsl:for-each>

  </wwsplits:Splits>
 </xsl:template>
</xsl:stylesheet>
